@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb no-print">
        <span>View {{ $vouchersNumber->voucher_type }}</span>
    </div>
    <h2 class="az-content-title no-print" style="display: inline">
        <span class="no-print">View</span> {{ $vouchersNumber->voucher_type }}
        <span class="no-print">
            <a href="javascript:history.back()" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to {{ $vouchersNumber->voucher_type }}
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <h4>
                        <span>
                            <strong>Voucher Number #:</strong>
                            {{ $vouchersNumber->voucher_number }}
                        </span>
                        <br>
                        <span>
                            <strong>Voucher Date:</strong>
                            {{ date('d-m-Y', strtotime($vouchersNumber->created_at)) }}
                        </span>
                        <br>
                        <span>
                            <strong>Voucher Type:</strong>
                            {{ $vouchersNumber->voucher_type }}
                        </span>
                        <br>
                        <span>
                            <strong>Business Partner:</strong>
                            {{ $voucherSingle->partner_name }}
                        </span>
                        <br>
                        <span>
                            <strong>Description:</strong>
                            {{ $voucherSingle->desciption }}
                        </span>
                    </h4>
                </div>
                <div class="mt-5">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Account Number</th>
                                <th>Account Title</th>
                                <th>Payment Mode</th>
                                <th>Instrument #</th>
                                <th>Remarks</th>
                                <th>Debit</th>
                                <th>Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($vouchersNumber->vouchers as $vouchers)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $vouchers->account_no }}</td>
                                    <td>{{ $vouchers->account_title }}</td>
                                    <td>{{ $vouchers->payment_mode }}</td>
                                    <td>{{ $vouchers->instrument }}</td>
                                    <td>{{ $vouchers->remarks }}</td>
                                    <td>{{ $vouchers->debit }}</td>
                                    <td>{{ $vouchers->credit }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="float-end">
                        <h5>Total Debit: {{ $vouchersNumber->vouchers->sum('debit') }}</h5>
                        <h5>Total Credit: {{ $vouchersNumber->vouchers->sum('credit') }}</h5>
                    </div>
                    <div class="no-print">
                        <a class="btn rounded shadow-base" title="Edit Journal Voucher" onclick="window.print()">
                            <i class="text-success fa-solid fa-print"></i>
                            <span class="text-success">Print</span>
                        </a>
                        {{-- <a class="btn rounded shadow-base" title="Edit Journal Voucher"
                            href="{{ route('voucher.print', \Crypt::encrypt($vouchersNumber->id_vouchers_unique_number)) }}">
                            <i class="text-success fa-solid fa-print"></i>
                            <span class="text-success">Print</span>
                        </a> --}}
                        <a class="btn rounded shadow-base" title="Edit Journal Voucher"
                            href="{{ route('voucher.edit', \Crypt::encrypt($vouchersNumber->id_vouchers_unique_number)) }}">
                            <i class="text-primary fa-solid fa-eye"></i>
                            <span class="text-primary">Edit</span>
                        </a>
                        <a class="btn rounded shadow-base" title="Delete Journal Voucher" data-toggle="modal"
                            data-target="#deleteModal"
                            data-id="{{ Crypt::encrypt($vouchersNumber->id_vouchers_unique_number) }}">
                            <i class="text-danger fa-solid fa-trash-can"></i>
                            <span class="text-danger">Remove</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('voucher/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
