@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Product Main Category</span>
        <span>Add Product Main Category</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Product Main Category<span>
            <a href="{{ url('product_cate_main/list') }}" class="btn border" style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Products Main Category List
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Product Category</h5>
                <form method="post" action="{{ url('product_cate_main/store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Category Name <span
                                        style="color:red;">*</span></label>
                                <input type="text" name="products_category_name" class="form-control" required />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Category Name (Urdu)
                                    Optional <span style="color:red;">*</span> </label>
                                <input type="text" name="products_category_name_urdu" class="form-control" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                            <select class="form-control" name="products_category_status" id="products_category_status">
                                <option value="1">Active</option>
                                <option value="0">In Active</option>
                            </select>
                        </div>
                    </div>

                    <a type="button" href="{{ url('product_cate_main/list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection
