@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Sub Control Account</span>
    </div>

    <div class="d-flex justify-content-between align-items-center">

        <div>
            <h2 class="az-content-title" style="display: inline">Sub Control Account List</h2>
            <nav aria-label="breadcrumb" class="mt-3">
                <ol class="breadcrumb bg-transparent p-2  border rounded">
                    <li class="breadcrumb-item">
                        <a href="{{ url('main_account') }}" class="text-decoration-none text-dark">
                            <i class="fas fa-home me-1"></i> Main Account List
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-dark" aria-current="page">
                        <a href="{{ url('control_account/' . $main_account->id_main_account) }}"
                            class="text-decoration-none text-dark"><i class="fas fa-folder-open me-1"></i>
                            {{ $main_account->main_account_name }}
                        </a>
                    </li>
                    <li class="breadcrumb-item active text-primary" aria-current="page">
                        <i class="fas fa-folder-open me-1"></i> {{ $control_account->control_account_name }}
                    </li>
                </ol>
            </nav>
        </div>
        <span>
            @can('Sub Control Account add')
                {{-- <a href="{{ url('sub_control_account/' . $main_account->id_main_account) }}" class="btn border"
                    style="float: left"><i class="fa-solid fa-bars-staggered"></i>
                    Back to Control Account
                </a> --}}
                <a href="javascript:window.history.back()" class="btn btn-outline-secondary me-2">
                    <i class="fas fa-arrow-left me-1"></i>
                    Back to Control Account
                </a>
                <button type="button" class="btn btn-az-primary" data-toggle="modal" data-target="#exampleModal">
                    <i class="fa-solid fa-plus"></i> Add Account
                </button>
            @endcan
        </span>
    </div>

    <div class="card card-body pd-20">
        <div class="row">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div>
                    <table id="example2" class="table ">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($sub_control_accounts as $key => $m_acc)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $m_acc->sub_control_account_number }}</td>
                                    <td>{{ $m_acc->sub_control_account_name }}</td>
                                    <td>{{ $m_acc->sca_urdu_name }}</td>
                                    <td>{{ $m_acc->created_at }}</td>
                                    <td>
                                        @can('Transaction Action list')
                                            <a class="btn rounded shadow-base text-info"
                                                href="{{ url('transaction_account/' . $main_account->id_main_account . '/' . $control_account->id_control_account . '/' . $m_acc->id_sub_control_account) }}">
                                                <i class="fa-solid fa-arrow-up-right-from-square"></i>
                                                <strong>Transaction Action</strong>
                                            </a>
                                        @endcan
                                        @can('Sub Control Account edit')
                                            <a type="button" class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#exampleModal2" data-id="{{ $m_acc->id_sub_control_account }}"
                                                data-name="{{ $m_acc->sub_control_account_name }}"
                                                data-urdu-name="{{ $m_acc->sca_urdu_name }}">
                                                <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                <strong class="text-primary">Edit</strong>
                                            </a>
                                        @endcan
                                        @can('Sub Control Account delete')
                                            <a href="#" class="btn rounded shadow-base" data-toggle="modal"
                                                data-target="#deleteModal" data-id="{{ $m_acc->id_sub_control_account }}">
                                                <i class="text-danger fa-solid fa-trash-can"></i>
                                                <strong class="text-danger">Remove</strong>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">کھا تہ</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-20p">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Sub Control Account Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Sub Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addMainAccountForm" action="{{ url('sub_control_account/store') }}" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="id_control_account">Main Account ID</label>
                            <input type="text" class="form-control" id="id_control_account" name="id_control_account"
                                value="{{ $control_account->id_control_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="sca_urdu_name_add" style="float: inline-end;">کھا تہ</label>
                            <input type="text" name="sca_urdu_name" class="form-control" id="sca_urdu_name_add"
                                dir="rtl" />
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="text-white btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Sub Control Account Modal -->
    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Sub Control Account</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editForm" method="POST">
                        @csrf
                        <div class="form-group" hidden>
                            <label for="id_control_account">Main Account ID</label>
                            <input type="text" class="form-control" id="id_control_account" name="id_control_account"
                                value="{{ $control_account->id_control_account }}" required>
                        </div>
                        <div class="form-group">
                            <label for="name">Account Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <br>
                        <div class="form-group">
                            <label for="sca_urdu_name_edit">کھا تہ</label>
                            <input type="text" name="sca_urdu_name" class="form-control" id="sca_urdu_name_edit"
                                dir="rtl" />
                            <input type="hidden" id="id_sub_control_account" name="id_sub_control_account">
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-az-primary">Save</button>
                    </form>
                    <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirm Deletion Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this sub-control account?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-white" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Sub Control Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Sub Control Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Sub Control Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Sub Control Account List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: true
            });

            // Handle Edit Button Click
            $('#exampleModal2').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var name = button.data('name');
                var urduName = button.data('urdu-name');
                var modal = $(this);

                modal.find('#name').val(name);
                modal.find('#sca_urdu_name_edit').val(urduName);
                modal.find('#id_sub_control_account').val(id);
                modal.find('#editForm').attr('action', "{{ url('sub_control_account/update') }}/" + id);
            });

            // Handle Delete Button Click
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var modal = $(this);

                modal.find('#deleteForm').attr('action', "{{ url('sub_control_account/delete') }}/" + id);
            });

            // Urdu Input Restriction
            $('#sca_urdu_name_add, #sca_urdu_name_edit').on('keypress', function(e) {
                var keyCode = e.which;
                if (!(keyCode >= 1536 && keyCode <= 1791)) {
                    e.preventDefault();
                }
            });
        });
    </script>
@endpush
