<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Brands extends Model
{
    protected $primaryKey = 'id_brands';
    protected $table = 'brands';
    protected $fillable = [
        'suppliers_id',
        'brands_name',
        'brands_abbrevation',
        'brands_logo',
        'brands_image',
        'brands_status',
        'created_by',
    ];

    public function supplierBrand()
    {
        return $this->hasMany(SupplierBrand::class, 'brand_id');
    }
    
    public function suppliers()
    {
        return $this->belongsTo(Suppliers::class, 'suppliers_id', 'id_supplier');
    }

    public function products()
    {
        return $this->hasMany(Products::class, 'brands_id', 'id_brands');
    }
}

