<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductStock extends Model
{
    use HasFactory;

    protected $table = 'products_stock';

    protected $fillable = [
        'pro_cate_main_id',
        'pro_cate_parent_id',
        'pro_cate_child_id',
        'quantity',
        'date',
        'status',
        'created_by',
    ];

    // Relationships with the main, parent, and child categories
    public function mainCategory()
    {
        return $this->belongsTo(ProductCategoryMain::class, 'pro_cate_main_id');
    }

    public function parentCategory()
    {
        return $this->belongsTo(ProductSubCategoryParent::class, 'pro_cate_parent_id');
    }

    public function childCategory()
    {
        return $this->belongsTo(ProductSubCategoryChild::class, 'pro_cate_child_id');
    }
}
