@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employee</span>
        <span>Add Employee</span>

    </div>
    <h2 class="az-content-title" style="display: inline">Add New Employee <span><a href="{{ url('employee') }}"
                class="btn btn-az-primary" style="float: right">Employees List</a></span></h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Employee</h5>
                <form method="post" action="{{ url('employee/store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Name</label>
                                <input type="text" name="employee_name" class="form-control" value="{{ old('employee_name') }}" required />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Number</label>
                                <input type="text" name="employee_no" class="form-control" value="{{ old('employee_no') }}" required />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Email</label>
                                <input type="text" name="employee_email" class="form-control" value="{{ old('employee_email') }}" required />
                            </div>
                        </div>


                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Address</label>
                                <input type="text" name="employee_address" class="form-control" value="{{ old('employee_address') }}" required />
                            </div>
                        </div>


                    </div>


                    <a type="button" href="{{ url('/employee') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


@endsection
