<?php

namespace App\Http\Controllers;

use App\assign_department_user;
use App\departments;
use App\countries;
use App\department_service;
use App\department_sub_service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\other_service;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Session;
use Yajra\DataTables\Facades\DataTables;


class DepartmentsController extends Controller
{
    protected $role_id;
    public function __construct()
    {
        $this->middleware('auth');
               
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (isset(request()->q)) {
            $departments = departments::where('id_departments', request()->q)->get();
        } else {
            $departments = departments::all();
        }
        $users = User::all();
        // $dep_users=assign_department_user::where();
        // dd()
        $services = other_service::where('status', 'Active')->where('parent_id', null)->get();
        return view('departments.index', compact('departments', 'users', 'services'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $countries = countries::all();
        $services = other_service::where('status', 'Active')->where('parent_id', null)->get();
        return view('departments.create', compact('countries', 'services'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'department_name' => 'required',
            // 'services' => 'required',
            // 'sub_services' => 'required'
        ]);

        $department = new departments();
        $department->department_name = $request->department_name;
        // $department->services = $request->services;
        // $department->sub_services = json_encode($request->sub_services);
        $department->save();

        if ($department) {
            session()->flash('success', 'Department Added Successfully!');

            return redirect()->back();
        } else {
            toastr()->error('An error has occurred please try again later.');
            //            session()->flash('error', $th->getMessage());
            return redirect()->back();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(department $department)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $edit_department = departments::where('id_departments', $dec_id)->first();
        $services = other_service::where('status', 'Active')->where('parent_id', null)->get();
        return view('departments.edit', compact('edit_department', 'services'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //        echo 'working';exit;
        $request->validate([
            'department_name' => 'required',
        ]);
        // dd($request);

        $dec_id = \Crypt::decrypt($request->a_id);

        //            echo $dec_id;exit;
        $department = departments::where('id_departments', $dec_id)->first();
        //             dd($department);
        $department->department_name = $request->department_name;
        // $department->services = $request->services;
        // $department->sub_services = json_encode($request->sub_services);
        $department->status = $request->department_status;

        $department->save();
        if ($department) {
            session()->flash('success', 'Department Updated Successfully!');

            return redirect()->back();
        } else {
            toastr()->error('An error has occurred please try again later.');
            return redirect()->back();
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $department_id = \Crypt::decrypt($id);
        $destroy_department = departments::findOrfail($department_id);
        $destroy_department->delete();
        session()->flash('success', 'Department Removed!');
        return back();
    }
    public function assign_user(Request $request)
    {
        $department_id = $request->d_id;
        // dd($request);
        $user = User::find($request->user_id);
        $department = departments::find($department_id);
        $check_user = assign_department_user::where('user_id', $request->user_id)->where('department_id', $department_id)->first();
        if ($check_user == null) {
            assign_department_user::create([
                'user_id'    => $request->user_id,
                'department_id'    => $department_id,
                'user_name'    => $user->name,
                'department_name'    => $department->department_name
            ]);
        } else {
            $check_user->user_id  = $request->user_id;
            $check_user->department_id    = $department_id;
            $check_user->user_name    = $user->name;
            if (isset($request->is_head)) {
                $check_user->is_head   = 1;
            }
            $check_user->department_name    = $department->department_name;
            $check_user->save();
        }

        session()->flash('success', 'Assign User');
        return back();
    }
    public function assign_services_department(Request $request)
    {
        // dd($request);
        $department_id = $request->d_id;
        $department = departments::find($department_id);
        $services_count = count($request->services);
        // dd($services_count);
        $data = $request->all();
        // dd($data);
        for ($i = 0; $i < $services_count; $i++) {
            // dd($i);
            $services = $data['services'][$i];
            // dd($services);
            if ($i == 0) {
                $store_services = new department_service();
                $store_services->department_id = $department_id;
                $store_services->service_id = $services;
                $store_services->save();
                $service_id = $store_services->id;
                // dd($service_id);
                $store_sub_services = new department_sub_service();
                $store_sub_services->departments_id = $department_id;
                $store_sub_services->services_id = $service_id;
                $store_sub_services->sub_services_id = json_encode($data['sub_services']);
                $store_sub_services->save();
            } else {
                $store_services = new department_service();
                $store_services->department_id = $department_id;
                $store_services->service_id = $services;
                $store_services->save();

                $service_id = $store_services->id;

                $store_sub_services = new department_sub_service();
                $store_sub_services->departments_id = $department_id;
                $store_sub_services->services_id = $service_id;
                $store_sub_services->sub_services_id = json_encode($data['sub_services' . $i]);
                $store_sub_services->save();
            }
        }

        $department->department_services_id = $store_services->id_department_services;
        $department->save();
        // dd($department);

        session()->flash('success', 'Assign User');
        return back();
    }
    public function assign_users_services_department(Request $request)
    {
        // dd($request);
        $request->validate([
            'dep_user' => 'required'
        ]);

        $services_count = count($request->services);
        // dd($services_count);
        $data = $request->all();
        // dd($data);
        for ($i = 0; $i < $services_count; $i++) {
            // dd($i);
            $services[] = $data['services'][$i];
            if ($i == 0) {
                $sub_services[] =  $services[$i] . '/' . implode(',', $data['sub_services']);
            } else {
                $sub_services[] =  $services[$i] . '/' . implode(',', $data['sub_services' . $i]);
            }
        }

        $user_dep = assign_department_user::where('department_id', $request->d_id)->where('user_id', $request->dep_user)->first();
        $user_dep->services_data = json_encode($sub_services);
        $user_dep->save();
        session()->flash('success', 'Services Assign To User Successfully');
        return redirect()->back();
    }
}
