<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $primaryKey = 'id_customers';
    protected $table = 'customers';
    protected $fillable = [
        'business_id',
        'campaign_id',
        'customer_name',
        'customer_name_urdu',
        'customer_email',
        'customer_ope_bal_dr',
        'customer_ope_bal_cr',
        'customer_ope_date',
        'customer_cell',
        'whatsapp_check',
        'whatsapp_number',
        'customer_address',
        'customer_address_urdu',
        'customer_phone1',
        'customer_phone2',
        'customer_type',
        'customer_reference',
        'customer_remarks',
        'customer_remarks_urdu',
        'city_id',
        'country',
        'customer_image',
        'sale_person',
        'accounts_customer_rating',
        'status',
        'created_by',
    ];

    public function sales()
    {
        return $this->hasMany(Sale::class, 'customer_id');
    }
}
