<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Products extends Model
{
    protected $primaryKey = 'id_products';
    protected $table = 'products';
    protected $fillable = [
        'brands_id',
        'products_name',
        'products_sale_price',
        'in_stock',
        'products_purchase_price',
        'products_retail_price',
        'category_id',
        'products_desc',
        'unit_type_id',
        'products_qt_per_unit',
        'measurement_unit_id',
        'products_threshold',
        'products_status',
    ];

    public function brand()
    {
        return $this->belongsTo(Brands::class, 'brands_id');
    }

    public function category()
    {
        return $this->belongsTo(ProductsCategory::class, 'category_id');
    }

    public function unit()
    {
        return $this->belongsTo(MeasurementUnit::class, 'measurement_unit_id');
    }
    
    public function stocks()
    {
        return $this->hasMany(Stocks::class, 'products_id');
    }

    public function images(): HasMany
    {
        return $this->hasMany(ProductImages::class, 'product_id', 'id_products');
    }
}
