@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employee</span>
        <span>Add Employee</span>

    </div>
    <h2 class="az-content-title" style="display: inline">Add New Employee <span>
        {{-- <a href="{{ url('employee') }}"
                class="btn btn-az-primary" style="float: right">Employees List</a> --}}

                <a href="{{ url('employee') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Employees
            </a>

            </span></h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Employee</h5>
                <form method="post" action="{{ url('employee/store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Name <span style="color:red;">*</span></label>
                                <input type="text" name="employee_name" class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Number <span style="color:red;">*</span></label>
                                <input type="text" name="employee_no" class="form-control" required />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Email <span style="color:red;">*</span></label>
                                <input type="text" name="employee_email" class="form-control" required />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Address <span style="color:red;">*</span></label>
                                <input type="text" name="employee_address" class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Phone 1 <span style="color:red;">*</span></label>
                            <input type="text" name="phone_1" class="form-control" required />
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Phone 2 <span style="color:red;">*</span></label>
                            <input type="text" name="phone_2" class="form-control" required />

                        </div>

                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Departments <span style="color:red;">*</span></label>
                            <select class="form-control" name="department" id="department" required>
                                <option value="">- Select -</option>
                                <option value="Administrator">Administrator</option>
                                <option value="Head">Head</option>
                            </select>
                        </div>
                    </div>
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">City <span style="color:red;">*</span></label>
                            <select class="form-control" name="city" id="city" required>
                                <option value="">Select City</option>
                                <option value="Karachi">Karachi</option>
                                <option value="Hydeabad">Hydeabad</option>
                            </select>

                        </div>

                        {{-- <div class="col-md-4">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Employee Type</label>
                            <select class="form-control" name="employee_type" id="employee_type">
                                <option value="">Other</option>
                                <option value="">SalesMan</option>
                                <option value="">Supplier</option>
                            </select>
                        </div> --}}

                        <div class="col-md-6">
                            <label class="az-content-label tx-11 tx-medium tx-gray-600">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="1">Active</option>
                                <option value="0">In Active</option>
                            </select>
                        </div>
                    </div>


                    <a type="button" href="{{ url('/employee') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


@endsection
