<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class GoodReceiptDetail extends Model
{
    protected $primaryKey = 'id_grd';
    protected $table = 'good_receipts_details';
    protected $fillable = [
        'good_receipts_id',
        'truck_id',
        'goods_name',
        'marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'remarks',
        'pro_cate_main_id',
        'pro_cate_parent_id',
        'pro_cate_child_id',
    ];

    public function goodReceipt()
    {
        return $this->belongsTo(GoodReceipts::class, 'good_receipts_id');
    }

    public function goodReceiptTruck()
    {
        return $this->belongsTo(GoodReceiptTruck::class, 'truck_id');
    }

    public function productMainCate()
    {
        return $this->belongsTo(ProductsCategoryMain::class, 'pro_cate_main_id', 'id_pro_cate_main');
    }

    public function productParentCate()
    {
        return $this->belongsTo(ProductsSubCategoryParent::class, 'pro_cate_parent_id', 'id_pro_sub_cat_parent');
    }

    public function productChildCate()
    {
        return $this->belongsTo(ProductsSubCategoryChild::class, 'pro_cate_child_id', 'id_pro_sub_cat_child');
    }
    // public function supplier()
    // {
    //     return $this->belongsTo(Suppliers::class, 'supplier_id');
    // }
    public function supplier()
    {
        return $this->belongsToThrough(Suppliers::class, GoodReceipts::class, 'supplier_id');
    }

    public function salesItemDetail()
    {
        return $this->hasMany(SalesItemDetail::class, 'good_detail_id');
    }
}
