<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Shortkut;
use Illuminate\Http\Request;

class ShortkutController extends Controller
{
    public function index()
    {
        $shortcuts = Shortkut::paginate(10); // Adjust pagination as needed
        return view('shortkut.index', compact('shortcuts'));
    }


    public function create()
    {
        return view('shortkut.create');
    }

    /**
     * Store the shortcut data.
     */
    public function store(Request $request)
{
    // Validate the request data
    $request->validate([
        'shortcut_name' => 'required|string|max:255',
        'shortcut_key_1' => 'nullable|string|max:255',
        'shortcut_key_2' => 'nullable|string|max:255',
    ]);

    // Simulate saving the data to the database
    // Uncomment and replace with your actual model
    Shortkut::create([
        'shortcut_name' => $request->shortcut_name,
        'shortcut_key_1' => $request->shortcut_key_1,
        'shortcut_key_2' => $request->shortcut_key_2,
    ]);

    // Redirect back with success message
    return redirect()
        ->route('shortkut.index')
        ->with('success', 'Shortcut saved successfully!');
}

// Display the edit form with the current shortcut data
public function edit($id)
{
    $shortkut = Shortkut::findOrFail($id);
    return view('shortkut.edit', compact('shortkut'));
}

// Update the shortcut record in the database
public function update(Request $request, $id)
{
    // Validate the request data
    $request->validate([
        'shortcut_name' => 'required|string|max:255',
        'shortcut_key_1' => 'nullable|string|max:255',
        'shortcut_key_2' => 'nullable|string|max:255',
    ]);

    // Find the shortcut by ID and update it
    $shortkut = Shortkut::findOrFail($id);
    $shortkut->update([
        'shortcut_name' => $request->shortcut_name,
        'shortcut_key_1' => $request->shortcut_key_1,
        'shortcut_key_2' => $request->shortcut_key_2,
    ]);

    // Redirect with a success message
    return redirect()
        ->route('shortkut.index')
        ->with('success', 'Shortcut updated successfully!');
}


public function fetchShortcuts()
    {
        try {
            // Fetch all shortcuts
            $shortcuts = Shortkut::all();

            return response()->json($shortcuts); // Return JSON response
        } catch (\Exception $e) {
            // Log the error and return a proper JSON response for debugging
            \Log::error('Error fetching shortcuts: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to fetch shortcuts'], 500);
        }
    }
public function destroy($id)
{
    $shortcuts = Shortkut::findOrFail($id);
        $shortcuts->delete();
        session()->flash('warning', "Shortcut Removed!");
        return redirect()->back();
}

}
