@extends('layouts.master')

@push('css')
@endpush

@section('content')
    <?php //echo "<pre>"; print_r($po_data); exit();
    ?>
    <style type="text/css">
        .tborder {
            border: 1px solid black !important;
        }

        table.customtble tbody tr td {
            padding: 0px 5px 0px 5px;
            /*border:1px solid #000;*/
            font-size: 13px;
            color: gray;

        }

        table.customtble thead tr th {
            padding: 0px 5px 0px 5px;
            /*border:1px solid #000;*/
            font-size: 14px;
            font-weight: bold;
        }

        @media print {
            table.customtble thead tr th {
                font-size: 11px;
            }

            table.customtble tbody tr td {
                font-size: 10px;
            }

            body * {
                visibility: hidden;
                margin-top: 0px !important;
            }

            .printableArea,
            .printableArea * {
                visibility: visible !important;
            }

            table {
                border-collapse: collapse;
            }

            @page {
                size: landscape
            }
        }
    </style>

    <div class="printableArea" id="printableArea">
        <form id="FormId" class="form-horizontal" method="POST" action="{{ route('dailySale') }}">
            {{ csrf_field() }}
            <div class="card">
                <div class="card-header  text-dark">
                    {{-- <h4 class="card-title mb-0">Sales Report Filter</h4> --}}
                </div>
                <div class="card-body">
                    <div class="row">
                        {{-- <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">Date</label>
                                    <input type="date" class="form-control" id="date" name="date"
                                        value="{{ old('date') }}" required>
                                </div>
                            </div> --}}
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="saledate" class="col-md-4 control-label">Sale Date</label>
                                <div class="input-group mydatepicker date date-picker margin-bottom-5"
                                    data-date-format="dd-mm-yyyy">

                                    <input type="text" id="saledate" required autocomplete="off"
                                        class="form-control form-filter" name="saledate" placeholder="From"
                                        value="<?php if (isset($saledate)) {
                                            echo date('m/d/Y', strtotime($saledate));
                                        } ?>">

                                </div>
                            </div>
                        </div>
                        <div class="col-md-1 mt-3">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i>
                                Run</button>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>

    <div>
        <div class="printableArea" id="printableArea">

            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default">

                        <div class="panel-body">
                            <div class="clearfix">

                            </div>
                            <br>
                            {{-- <hr class="hidden"> --}}
                            <div class="row card p-3">
                                <div class="col-md-12">
                                    <h3 class="text-center"> Daily Sales</h3>
                                </div>


                                <!-- end row -->


                                <div class="m-h-50">&nbsp;</div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="table-responsive">
                                            <!-- <table class="table table-bordered m-t-30" id="tblproducts"> -->
                                            <!-- <table id="tblreport" class="table table-bordered customtble"> -->
                                                <table id="tblreport" class="display nowrap table-bordered" cellspacing="0" style="width: 100%;">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Customer</th>
                                                            <th>Product</th>
                                                            <th>Bori</th>
                                                            <th>Weight</th>
                                                            <th>Rate</th>
                                                            <th>Total</th>
                                                            <th>Received</th>
                                                            <th>Balance</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            // Initialize variables to prevent undefined errors
                                                            $totalPending = 0;
                                                            $totalReceived = 0;
                                                            $grandTotal = 0;
                                                            $counter = 0;
                                                        @endphp

                                                        @if ($saleReport && !empty($saleReport))
                                                            @foreach ($saleReport as $row)
                                                                @php
                                                                    // Sanitize numeric values
                                                                    $amount = isset($row['amount']) && is_numeric($row['amount']) ? $row['amount'] : 0;
                                                                    $paid = isset($row['paid']) && is_numeric($row['paid']) ? $row['paid'] : 0;
                                                                    $balance = isset($row['balance']) && is_numeric(str_replace(',', '', $row['balance']))
                                                                        ? str_replace(',', '', $row['balance'])
                                                                        : 0;

                                                                    // Update totals
                                                                    $grandTotal += $amount;
                                                                    $totalReceived += $paid;
                                                                    $totalPending += $balance;

                                                                    $counter++;
                                                                @endphp
                                                                <tr>
                                                                    <td>{{ $counter }}</td>
                                                                    <td>{{ $row['customer_name'] }}</td>
                                                                    <td>
                                                                        {{ $row['products_category_name'] ?? '' }} /
                                                                        {{ $row['sub_name'] ?? '' }} /
                                                                        {{ $row['child_name'] ?? '' }}
                                                                    </td>
                                                                    <td>{{ $row['bori'] ?? '' }}</td>
                                                                    <td>{{ $row['weight'] ?? '' }}</td>
                                                                    <td>{{ $row['rate'] ?? '' }}</td>
                                                                    <td>{{ number_format($amount, 2) }}</td>
                                                                    <td>{{ number_format($paid, 2) }}</td>
                                                                    <td>{{ number_format($balance, 2) }}</td>
                                                                </tr>
                                                            @endforeach
                                                        @else
                                                            <tr>
                                                                <td colspan="8" class="text-center">No records found.</td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                    <tfoot>
                                                        <tr>
                                                            <th colspan="6" class="text-right">Total:</th>
                                                            <th>{{ number_format($grandTotal, 2) }}</th>
                                                            <th>{{ number_format($totalReceived, 2) }}</th>
                                                            <th>{{ number_format($totalPending, 2) }}</th>
                                                        </tr>
                                                    </tfoot>
                                                </table>


                                        </div>
                                    </div>
                                </div>

                                <hr>
                                <div class="hidden-print">
                                    <div class="pull-right">
                                        <a id="printbutton" href="#"
                                            class="btn btn-inverse waves-effect waves-light hidden"
                                            onclick='window.print();'><i class="fa fa-print"></i></a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </div>
@endsection

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- jQuery (required for Select2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $('#business_partner').select2({
        theme: 'default'
    });
    $('#partner_name').select2({
        theme: 'default'
    });
    jQuery(document).ready(function() {
        // Initialize DatePickers
        $('#saledate').datepicker({
            autoclose: true,
            todayHighlight: true
        });
        $('#tblreport').DataTable({
            lengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            //                            stateSave: true,
            fixedHeader: {
                header: true
            },
            "bSort": false,
            dom: "Bfrtlip",
            buttons: [{
                    extend: "excel",
                    title: 'Sale Summary',
                    filename: 'saleSummary'
                },
                //                                {extend: "pdf", title: 'Sale Summary', orientation: 'landscape'}
            ],
            responsive: !0
        });
    });

    shortcut.add("ctrl+p", function() {
        printDiv('printableArea');
    });
</script>
