@extends('layouts.master')
@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shortcut Index</title>
    <!-- Add Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div>
        <div class="row">
            <div class="col-md-12">
                <div class="card shadow">
                    <div class="card-header text-dark">
                        <h3 class="card-title mb-0">Shortcut List</h3>
                        <a href="{{ route('shortkut.create') }}" class="btn btn-primary float-end">Add New Shortcut</a>
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif

                        <table class="table table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Shortcut Name</th>
                                    <th>Shortcut Key 1 (Ctrl)</th>
                                    <th>Shortcut Key 2 (Alphabet)</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($shortcuts as $shortcut)
                                    <tr>
                                        <td>{{ $shortcut->id_key }}</td>
                                        <td>{{ $shortcut->shortcut_name }}</td>
                                        <td>{{ $shortcut->shortcut_key_1 }}</td>
                                        <td>{{ $shortcut->shortcut_key_2 }}</td>
                                         <td>
                                            <a href="{{ route('shortkut.edit', $shortcut->id_key) }}" class="btn btn-primary">Edit</a>

                                            <form action="{{ route('shortkut.destroy', $shortcut->id_key ) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No shortcuts found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center">
                            {{ $shortcuts->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
@endsection
